/*
 * Decompiled with CFR 0.152.
 */
package com.maconomy.util;

import com.maconomy.util.MVersionStringException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVersionUtil {
    public static int compareVersions(String string, String string2) throws MVersionStringException {
        return MVersionUtil.compareVersions(string, string2, null);
    }

    public static int compareVersions(String string, String string2, Integer n) throws MVersionStringException {
        List<Integer> list = MVersionUtil.versionString2List(string);
        List<Integer> list2 = MVersionUtil.versionString2List(string2);
        int n2 = n == null ? list.size() : Math.min(n, list.size());
        int n3 = n == null ? list2.size() : Math.min(n, list2.size());
        for (int i = 0; i < n2 && i < n3; ++i) {
            int n4;
            int n5 = list.get(i);
            if (n5 < (n4 = list2.get(i).intValue())) {
                return -1;
            }
            if (n5 <= n4) continue;
            return 1;
        }
        if (n2 < n3) {
            return -1;
        }
        if (n2 > n3) {
            return 1;
        }
        return 0;
    }

    private static List<Integer> versionString2List(String string) throws MVersionStringException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "._");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() == 0) {
                n = 0;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = string2.length();
                boolean bl = true;
                for (int i = 0; bl && i < n2; ++i) {
                    char c = string2.charAt(i);
                    if (Character.isDigit(c)) {
                        stringBuilder.append(c);
                        continue;
                    }
                    bl = false;
                }
                String string3 = stringBuilder.toString();
                try {
                    n = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MVersionStringException("Invalid version string \"" + string + "\"\nnot in format <number>{\".\"<number>}*.\n" + "String \"" + string2 + "\" does not represent an integer.");
                }
            }
            arrayList.add(new Integer(n));
        }
        return arrayList;
    }

    public static boolean isValidReleaseVersion(String string) {
        try {
            List<Integer> list = MVersionUtil.versionString2List(string);
            return list.size() > 0;
        }
        catch (MVersionStringException mVersionStringException) {
            return false;
        }
    }

    public static boolean versionLT(String string, String string2) throws MVersionStringException {
        return MVersionUtil.compareVersions(string, string2) < 0;
    }

    public static boolean versionLE(String string, String string2) throws MVersionStringException {
        return MVersionUtil.compareVersions(string, string2) <= 0;
    }

    public static boolean versionGT(String string, String string2) throws MVersionStringException {
        return MVersionUtil.compareVersions(string, string2) > 0;
    }

    public static boolean versionGE(String string, String string2) throws MVersionStringException {
        return MVersionUtil.compareVersions(string, string2) >= 0;
    }

    public static boolean versionEquals(String string, String string2) throws MVersionStringException {
        return MVersionUtil.compareVersions(string, string2) == 0;
    }

    public static String appAsPrintString(String string, String string2) {
        return string + " P" + string2;
    }
}

