/*
 * Decompiled with CFR 0.152.
 */
package com.maconomy.util;

import com.maconomy.util.MAbstractPlatform;
import com.maconomy.util.MStringUtil;
import com.maconomy.util.MVersionStringException;
import com.maconomy.util.MVersionUtil;

class MMacOSX
extends MAbstractPlatform {
    private static String APPLE_LAF_USESCREENMENUBAR = "apple.laf.useScreenMenuBar";
    private static String COM_APPLE_MACOS_USESCREENMENUBAR = "com.apple.macos.useScreenMenuBar";

    MMacOSX() {
    }

    private void setSystemPropertiesForAppletAndApplications() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemPropertiesForApplet() {
        Object object = this.platformObjectLock;
        synchronized (object) {
            super.setSystemPropertiesForApplet();
            this.setSystemPropertiesForAppletAndApplications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemPropertiesForApplication() {
        Object object = this.platformObjectLock;
        synchronized (object) {
            this.setSystemPropertiesForAppletAndApplications();
            if (!this.isJavaWebStart15OrNewer()) {
                boolean bl;
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Maconomy");
                boolean bl2 = bl = !this.isJava170OrNewer();
                if (bl) {
                    System.setProperty("apple.awt.graphics.UseQuartz", "true");
                }
                System.setProperty(APPLE_LAF_USESCREENMENUBAR, "true");
                System.setProperty(COM_APPLE_MACOS_USESCREENMENUBAR, "true");
                if (bl) {
                    System.setProperty("apple.awt.antialiasing", "on");
                    System.setProperty("apple.awt.textantialiasing", "on");
                    System.setProperty("apple.awt.fractionalmetrics", "on");
                    System.setProperty("apple.awt.rendering", "speed");
                    System.setProperty("apple.awt.graphics.EnableLazyDrawing", "true");
                    System.setProperty("apple.awt.graphics.EnableLazyDrawingQueueSize", "65536");
                }
                System.setProperty("apple.awt.window.position.forceSafeCreation", "true");
                System.setProperty("apple.awt.window.position.forceSafeProgrammaticPositioning", "true");
                System.setProperty("apple.awt.window.position.forceSafeUserPositioning", "true");
            }
        }
    }

    private static final String getMacOSXVersion() {
        return System.getProperty("os.version");
    }

    private static boolean isMacOSXNNOrNewer(String string) {
        String string2 = MMacOSX.getMacOSXVersion();
        if (string2 == null) {
            return false;
        }
        try {
            return MVersionUtil.compareVersions(string2, string) >= 0;
        }
        catch (MVersionStringException mVersionStringException) {
            return false;
        }
    }

    private static boolean isMacOSXNN(String string) {
        String string2 = MMacOSX.getMacOSXVersion();
        if (string2 == null) {
            return false;
        }
        try {
            return MVersionUtil.compareVersions(string2, string, new Integer(2)) == 0;
        }
        catch (MVersionStringException mVersionStringException) {
            return false;
        }
    }

    public boolean isMacOSX() {
        return true;
    }

    public boolean isMacOSX105OrNewer() {
        return MMacOSX.isMacOSXNNOrNewer("10.5");
    }

    public boolean isMacOSX106OrNewer() {
        return MMacOSX.isMacOSXNNOrNewer("10.6");
    }

    public boolean isCocoa() {
        String string = System.getProperty("os.arch");
        return !this.isJava160OrNewer() && ("ppc".equals(string) || "i386".equals(string));
    }

    public boolean isUsingMacOSXPreferenceMenuItem() {
        return !this.isApplet();
    }

    public boolean isUsingMacOSXAboutMenuItem() {
        return !this.isApplet();
    }

    public boolean isUsingMacOSXQuitMenuItem() {
        return !this.isApplet();
    }

    public boolean isUsingMacOSXScrollbarVisibillity() {
        return true;
    }

    public boolean isUsingMacOSXMenuBar() {
        if (this.isApplet()) {
            return false;
        }
        String string = System.getProperty(APPLE_LAF_USESCREENMENUBAR);
        if (string instanceof String) {
            return string.equals("true");
        }
        String string2 = System.getProperty(COM_APPLE_MACOS_USESCREENMENUBAR);
        if (string2 instanceof String) {
            return string.equals("true");
        }
        return false;
    }

    public int getIntrudingResizeHandleSize() {
        return 15;
    }

    public boolean isUsingCloseButtonOnModalDialog() {
        return false;
    }

    public static boolean isMacOSXPlatform() {
        String string = System.getProperty("os.name");
        return string != null && MStringUtil.cachedToDanishUpperCase(string).startsWith("MAC");
    }

    public boolean isUsingMenuItemIcon() {
        return this.isApplet();
    }
}

