/*
 * Decompiled with CFR 0.152.
 */
package com.maconomy.util;

import com.maconomy.util.MPlatform;
import com.maconomy.util.MThisPlatform;
import com.maconomy.util.MVersionStringException;
import com.maconomy.util.MVersionUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JDialog;
import javax.swing.JScrollPane;

abstract class MAbstractPlatform
implements MPlatform {
    protected static final Object platformStaticLock = new Object();
    protected final Object platformObjectLock = new Object();
    private boolean isApplet = false;
    private static final String JAVAWSDASH = "javaws-";
    private static final char replacementChar = '_';
    private static final HashSet<Integer> legalChars = new HashSet<Integer>(Arrays.asList(45, 95, 43, 46, 38, 64));
    private static Boolean isJavaWebStart15OrNewerResult = null;
    private static Boolean isJavaWebStart16OrNewerResult = null;
    private static Boolean isJava150Result = null;
    private static Boolean isJava150_06OrNewerResult = null;
    private static Boolean isJava150_12OrNewerResult = null;
    private static Boolean isJava150_16result = null;
    private static Boolean isJava160Result = null;
    private static Boolean isJava16OrNewerResult = null;
    private static Boolean isJava16O_07rNewerResult = null;
    private static Boolean isJava16O_10OrNewerResult = null;
    private static Boolean isJava16O_18Result = null;
    private static Boolean isJava160_20Result = null;
    private static Boolean isJava160_21Result = null;
    private static Boolean isJava160_22Result = null;
    private static Boolean isJava160_29Result = null;
    private static Boolean isJava17OrNewerResult = null;
    private static Boolean isJava170_25OrNewerResult = null;
    private static Boolean isJava170_40OrNewerResult = null;
    private static Boolean isJava180_60OrNewerResult = null;
    private static Boolean isNewGenerationPluginResult = null;
    private static final MCachedSystemPropertyEqualsResult isJava32Bit_Result = new MCachedSystemPropertyEqualsResult("sun.arch.data.model", "32");
    private static final MCachedSystemPropertyEqualsResult isJava64Bit_Result = new MCachedSystemPropertyEqualsResult("sun.arch.data.model", "64");
    private static final MCachedSystemPropertyIndexOfResult isJavaClientVM_Result = new MCachedSystemPropertyIndexOfResult("java.vm.name", "Client VM");
    private static final MCachedSystemPropertyIndexOfResult isJavaServerVM_Result = new MCachedSystemPropertyIndexOfResult("java.vm.name", "Server VM");
    private boolean browserNameSet = false;
    private String browserName;
    private static final MCachedSystemPropertyEqualsResult isWorkspaceAnalyzer = new MCachedSystemPropertyEqualsResult("com.maconomy.workspaceanalyzer", "true");

    MAbstractPlatform() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemPropertiesForApplet() {
        Object object = this.platformObjectLock;
        synchronized (object) {
            this.isApplet = true;
        }
        if (!this.isJava180_60OrNewer()) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemPropertiesForApplication() {
        Object object = this.platformObjectLock;
        synchronized (object) {
        }
    }

    public String getJavaVersionAndVendor() {
        return System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")";
    }

    public static final String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static final String getJavaVMVersion() {
        return System.getProperty("java.vm.version");
    }

    public static final String getJavaWebStartVersion() {
        String string = System.getProperty("javawebstart.version");
        if (string != null) {
            try {
                return string.substring(JAVAWSDASH.length());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isApplet() {
        Object object = this.platformObjectLock;
        synchronized (object) {
            return this.isApplet;
        }
    }

    public boolean isMacOSX() {
        return false;
    }

    public boolean isMacOSX103() {
        return false;
    }

    public boolean isMacOSX104OrNewer() {
        return false;
    }

    public boolean isMacOSX105OrNewer() {
        return false;
    }

    public boolean isMacOSX106OrNewer() {
        return false;
    }

    public boolean isWindows() {
        return false;
    }

    public boolean isLinux() {
        return false;
    }

    private static boolean isLegalCharacter(int n) {
        return Character.isLetter(n) || Character.isDigit(n) || legalChars.contains(n);
    }

    public String removeIllegalCharsInFilename(String string) {
        MPlatform mPlatform = MThisPlatform.getThisPlatform();
        if (mPlatform.isWindows() && !mPlatform.isJava170_40OrNewer()) {
            return string.replaceAll("[^a-zA-Z0-9 \u00e6\u00f8\u00e5\u00c6\u00d8\u00c5\\-_\\+\\.&@]", "_");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isHighSurrogate(c)) {
                char c2;
                if (i + 1 >= n || !Character.isLowSurrogate(c2 = string.charAt(i++))) break;
                int n2 = Character.toCodePoint(c, c2);
                if (MAbstractPlatform.isLegalCharacter(n2)) {
                    stringBuilder.append(c);
                    stringBuilder.append(c2);
                    continue;
                }
                stringBuilder.append('_');
                continue;
            }
            if (MAbstractPlatform.isLegalCharacter(c)) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    private static boolean isJavaNNOrNewer(String string) {
        String string2 = MAbstractPlatform.getJavaVersion();
        if (string2 == null) {
            return false;
        }
        try {
            return MVersionUtil.compareVersions(string2, string) >= 0;
        }
        catch (MVersionStringException mVersionStringException) {
            return false;
        }
    }

    private static boolean isJavaNN(String string) {
        String string2 = MAbstractPlatform.getJavaVersion();
        if (string2 == null) {
            return false;
        }
        try {
            return MVersionUtil.compareVersions(string2, string) == 0;
        }
        catch (MVersionStringException mVersionStringException) {
            return false;
        }
    }

    private static boolean isJavaNN(String string, int n) {
        String string2 = MAbstractPlatform.getJavaVersion();
        if (string2 == null) {
            return false;
        }
        try {
            return MVersionUtil.compareVersions(string2, string, n) == 0;
        }
        catch (MVersionStringException mVersionStringException) {
            return false;
        }
    }

    private static boolean isJavaWebStartNNOrNewer(String string) {
        String string2 = MAbstractPlatform.getJavaWebStartVersion();
        if (string2 == null) {
            return false;
        }
        try {
            return MVersionUtil.compareVersions(string2, string) >= 0;
        }
        catch (MVersionStringException mVersionStringException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJavaWebStart15OrNewer() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJavaWebStart15OrNewerResult == null) {
                isJavaWebStart15OrNewerResult = MAbstractPlatform.isJavaWebStartNNOrNewer("1.5") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJavaWebStart15OrNewerResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJavaWebStart16OrNewer() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJavaWebStart16OrNewerResult == null) {
                isJavaWebStart16OrNewerResult = MAbstractPlatform.isJavaWebStartNNOrNewer("1.6") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJavaWebStart16OrNewerResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava150() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava150Result == null) {
                isJava150Result = MAbstractPlatform.isJavaNN("1.5.0", 3) ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava150Result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava150_06OrNewer() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava150_06OrNewerResult == null) {
                isJava150_06OrNewerResult = MAbstractPlatform.isJavaNNOrNewer("1.5.0_06") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava150_06OrNewerResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava150_12OrNewer() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava150_12OrNewerResult == null) {
                isJava150_12OrNewerResult = MAbstractPlatform.isJavaNNOrNewer("1.5.0_12") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava150_12OrNewerResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava150_016() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava150_16result == null) {
                isJava150_16result = MAbstractPlatform.isJavaNN("1.5.0_16") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava150_16result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava160() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava160Result == null) {
                isJava160Result = MAbstractPlatform.isJavaNN("1.6.0", 3) ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava160Result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava160OrNewer() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava16OrNewerResult == null) {
                isJava16OrNewerResult = MAbstractPlatform.isJavaNNOrNewer("1.6.0") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava16OrNewerResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava160_07OrNewer() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava16O_07rNewerResult == null) {
                isJava16O_07rNewerResult = MAbstractPlatform.isJavaNNOrNewer("1.6.0_07") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava16O_07rNewerResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava160_10OrNewer() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava16O_10OrNewerResult == null) {
                isJava16O_10OrNewerResult = MAbstractPlatform.isJavaNNOrNewer("1.6.0_10") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava16O_10OrNewerResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava160_18() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava16O_18Result == null) {
                isJava16O_18Result = MAbstractPlatform.isJavaNN("1.6.0_18") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava16O_18Result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava160_20OrNewer() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava160_20Result == null) {
                isJava160_20Result = MAbstractPlatform.isJavaNNOrNewer("1.6.0_20") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava160_20Result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava160_21OrNewer() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava160_21Result == null) {
                isJava160_21Result = MAbstractPlatform.isJavaNNOrNewer("1.6.0_21") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava160_21Result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava160_22OrNewer() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava160_22Result == null) {
                isJava160_22Result = MAbstractPlatform.isJavaNNOrNewer("1.6.0_22") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava160_22Result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava160_29() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava160_29Result == null) {
                isJava160_29Result = MAbstractPlatform.isJavaNN("1.6.0_29") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava160_29Result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava170OrNewer() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava17OrNewerResult == null) {
                isJava17OrNewerResult = MAbstractPlatform.isJavaNNOrNewer("1.7.0") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava17OrNewerResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava170_25OrNewer() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava170_25OrNewerResult == null) {
                isJava170_25OrNewerResult = MAbstractPlatform.isJavaNNOrNewer("1.7.0_25") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava170_25OrNewerResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava170_40OrNewer() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava170_40OrNewerResult == null) {
                isJava170_40OrNewerResult = MAbstractPlatform.isJavaNNOrNewer("1.7.0_40") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava170_40OrNewerResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJava180_60OrNewer() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isJava180_60OrNewerResult == null) {
                isJava180_60OrNewerResult = MAbstractPlatform.isJavaNNOrNewer("1.8.0_60") ? Boolean.TRUE : Boolean.FALSE;
            }
            return isJava180_60OrNewerResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNewGenerationPlugin() {
        Object object = platformStaticLock;
        synchronized (object) {
            if (isNewGenerationPluginResult == null) {
                isNewGenerationPluginResult = this.isApplet() && this.isMacOSX() && this.isJava170OrNewer() ? Boolean.TRUE : Boolean.valueOf(this.isApplet() && Boolean.valueOf(System.getProperty("deployment.jpi.mode.new")) != false);
            }
            return isNewGenerationPluginResult;
        }
    }

    public boolean isJava32Bit() {
        return (Boolean)isJava32Bit_Result.get();
    }

    public boolean isJava64Bit() {
        return (Boolean)isJava64Bit_Result.get();
    }

    public boolean isJavaClientVM() {
        return (Boolean)isJavaClientVM_Result.get();
    }

    public boolean isJavaServerVM() {
        return (Boolean)isJavaServerVM_Result.get();
    }

    public boolean isCocoa() {
        return false;
    }

    public boolean isUsingMacOSXPreferenceMenuItem() {
        return false;
    }

    public boolean isUsingMacOSXAboutMenuItem() {
        return false;
    }

    public boolean isUsingMacOSXQuitMenuItem() {
        return false;
    }

    public boolean isUsingMacOSXMenuBar() {
        return false;
    }

    public boolean isUsingMacOSXScrollbarVisibillity() {
        return false;
    }

    public void setScrollbarVisibillityPolicy(JScrollPane jScrollPane) {
        if (jScrollPane != null && this.isUsingMacOSXScrollbarVisibillity()) {
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
        } else if (jScrollPane != null) {
            jScrollPane.setHorizontalScrollBarPolicy(30);
            jScrollPane.setVerticalScrollBarPolicy(20);
        }
    }

    public int getIntrudingResizeHandleSize() {
        return 0;
    }

    public boolean isUsingCloseButtonOnModalDialog() {
        return true;
    }

    public void setCloseButtonBehaviourOnModalDialog(JDialog jDialog) {
        if (jDialog != null && !this.isUsingCloseButtonOnModalDialog()) {
            jDialog.setDefaultCloseOperation(0);
        } else if (jDialog != null) {
            jDialog.setDefaultCloseOperation(2);
        }
    }

    public boolean isUsingMenuItemIcon() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrowserNameForApplet(String string) {
        Object object = this.platformObjectLock;
        synchronized (object) {
            assert (this.isApplet) : "Precondition check: not running in a JApplet";
            assert (!this.browserNameSet) : "Precondition check: attempt to set 'browserName' more than once";
            this.browserNameSet = true;
            this.browserName = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBrowserName() {
        Object object = this.platformObjectLock;
        synchronized (object) {
            return this.browserName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnimationCapable() {
        Object object = this.platformObjectLock;
        synchronized (object) {
            return !this.isMacOSX() || !this.isApplet() || this.isNewGenerationPlugin() || !"firefox".equalsIgnoreCase(this.getBrowserName());
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMSIE() {
        Object object = this.platformObjectLock;
        synchronized (object) {
            return this.isApplet() && "msie".equalsIgnoreCase(this.getBrowserName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSafari() {
        Object object = this.platformObjectLock;
        synchronized (object) {
            return this.isApplet() && "safari".equalsIgnoreCase(this.getBrowserName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFireFox() {
        Object object = this.platformObjectLock;
        synchronized (object) {
            return this.isApplet() && "firefox".equalsIgnoreCase(this.getBrowserName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpera() {
        Object object = this.platformObjectLock;
        synchronized (object) {
            return this.isApplet() && "opera".equalsIgnoreCase(this.getBrowserName());
        }
    }

    public boolean isWorkspaceAnalyzer() {
        return (Boolean)isWorkspaceAnalyzer.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MCachedSystemPropertyIndexOfResult
    extends MAbstractCachedResult<Boolean> {
        private final String propertyName;
        private final String indexOfPropertyValue;

        public MCachedSystemPropertyIndexOfResult(String string, String string2) {
            this.propertyName = string;
            this.indexOfPropertyValue = string2;
        }

        @Override
        protected final Boolean calculateResult() {
            String string = System.getProperty(this.propertyName);
            return string != null && this.indexOfPropertyValue != null && string.indexOf(this.indexOfPropertyValue) >= 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MCachedSystemPropertyEqualsResult
    extends MAbstractCachedResult<Boolean> {
        private final String propertyName;
        private final String truePropertyValue;

        public MCachedSystemPropertyEqualsResult(String string, String string2) {
            this.propertyName = string;
            this.truePropertyValue = string2;
        }

        @Override
        protected final Boolean calculateResult() {
            return this.truePropertyValue != null && this.truePropertyValue.equals(System.getProperty(this.propertyName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MAbstractCachedResult<T> {
        private T cachedResult;
        private ReadWriteLock cachedResultLock = new ReentrantReadWriteLock();

        private MAbstractCachedResult() {
        }

        protected abstract T calculateResult();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            try {
                this.cachedResultLock.readLock().lock();
                if (this.cachedResult == null) {
                    try {
                        this.cachedResultLock.readLock().unlock();
                        this.cachedResultLock.writeLock().lock();
                        if (this.cachedResult == null) {
                            this.cachedResult = this.calculateResult();
                        }
                    }
                    finally {
                        this.cachedResultLock.readLock().lock();
                        this.cachedResultLock.writeLock().unlock();
                    }
                }
                T t = this.cachedResult;
                return t;
            }
            finally {
                this.cachedResultLock.readLock().unlock();
            }
        }
    }
}

