/*
 * Decompiled with CFR 0.152.
 */
package com.maconomy.gss.client.sspi;

import com.maconomy.gss.client.sspi.IWindowsCredentialsHandle;
import com.maconomy.gss.client.sspi.IWindowsSecurityContext;
import com.maconomy.gss.client.sspi.WindowsAccountImpl;
import com.maconomy.gss.client.sspi.WindowsCredentialsHandleImpl;
import com.sun.jna.platform.win32.Secur32;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.ptr.IntByReference;

public class WindowsSecurityContextImpl
implements IWindowsSecurityContext {
    private static volatile boolean debug = false;
    private String _principalName;
    private String _securityPackage;
    private Sspi.SecBufferDesc _token = null;
    private Sspi.CtxtHandle _ctx = null;
    private IntByReference _attr;
    private Sspi.CredHandle _credentials;
    private boolean _continue;
    private int deleg_flag = 276;

    public String getSecurityPackage() {
        return this._securityPackage;
    }

    public byte[] getToken() {
        return this._token == null ? null : this._token.getBytes();
    }

    public static IWindowsSecurityContext getCurrent(String string, String string2) {
        String string3 = WindowsAccountImpl.getCurrentUsername();
        IWindowsCredentialsHandle iWindowsCredentialsHandle = WindowsCredentialsHandleImpl.getCurrent(string3, string);
        iWindowsCredentialsHandle.initialize();
        WindowsSecurityContextImpl windowsSecurityContextImpl = new WindowsSecurityContextImpl();
        windowsSecurityContextImpl.setPrincipalName(string3);
        windowsSecurityContextImpl.setCredentialsHandle(iWindowsCredentialsHandle.getHandle());
        windowsSecurityContextImpl.setSecurityPackage(string);
        return windowsSecurityContextImpl;
    }

    public void initialize(Sspi.CtxtHandle ctxtHandle, Sspi.SecBufferDesc secBufferDesc, String string) {
        this._attr = new IntByReference();
        this._token = new Sspi.SecBufferDesc(2, 12288);
        this._ctx = new Sspi.CtxtHandle();
        int n = Secur32.INSTANCE.InitializeSecurityContext(this._credentials, ctxtHandle, string, this.deleg_flag, 0, 16, secBufferDesc, 0, this._ctx, this._token, this._attr, null);
        if (secBufferDesc != null && secBufferDesc.pBuffers != null) {
            for (Sspi.SecBuffer.ByReference byReference : secBufferDesc.pBuffers) {
                if (byReference.pvBuffer == null) continue;
                Secur32.INSTANCE.FreeContextBuffer(byReference.pvBuffer);
                byReference.cbBuffer = 0;
            }
        }
        switch (n) {
            case 590610: {
                this._continue = true;
                break;
            }
            case 0: {
                this._continue = false;
                break;
            }
            default: {
                if (debug) {
                    System.out.println("Error during attempted SSPI service ticket retrieval: InitializeSecurityContext function");
                }
                throw new Win32Exception(n);
            }
        }
    }

    public void dispose() {
        WindowsSecurityContextImpl.dispose(this._ctx);
    }

    public static boolean dispose(Sspi.CtxtHandle ctxtHandle) {
        if (ctxtHandle != null && !ctxtHandle.isNull()) {
            int n = Secur32.INSTANCE.DeleteSecurityContext(ctxtHandle);
            if (0 != n) {
                throw new Win32Exception(n);
            }
            return true;
        }
        return false;
    }

    public String getPrincipalName() {
        return this._principalName;
    }

    public void setPrincipalName(String string) {
        this._principalName = string;
    }

    public Sspi.CtxtHandle getHandle() {
        return this._ctx;
    }

    public void setCredentialsHandle(Sspi.CredHandle credHandle) {
        this._credentials = credHandle;
    }

    public void setToken(byte[] byArray) {
        this._token = new Sspi.SecBufferDesc(2, byArray);
    }

    public void setSecurityPackage(String string) {
        this._securityPackage = string;
    }

    public void setSecurityContext(Sspi.CtxtHandle ctxtHandle) {
        this._ctx = ctxtHandle;
    }

    public boolean getContinue() {
        return this._continue;
    }

    public void setContinue(boolean bl) {
        this._continue = bl;
    }

    public void setDebug(boolean bl) {
        debug = bl;
    }
}

