/*
 * Decompiled with CFR 0.152.
 */
package com.maconomy.gss.client;

import com.maconomy.client.MClientProperties;
import com.maconomy.gss.LoginCallBackHandler;
import com.maconomy.gss.client.sspi.IWindowsCredentialsHandle;
import com.maconomy.gss.client.sspi.IWindowsSecurityContext;
import com.maconomy.gss.client.sspi.WindowsSecurityContextImpl;
import com.maconomy.util.MThisPlatform;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.krb5.Credentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MKerberosSingleLoginCredentials {
    private static volatile boolean debug = false;
    private static volatile boolean nativeSSO = true;

    public static byte[] getTicket(String string, String string2, String string3, Map<String, String> map, boolean bl) throws SecurityException {
        Object object;
        if (map != null && map.get(string) == null) {
            map.put(string, string2);
            object = Credentials.acquireDefaultCreds();
            string = object.getClient().getRealmAsString();
        }
        MKerberosSingleLoginCredentials.setupKerberosProperties(string, string2, map, bl);
        object = MKerberosSingleLoginCredentials.isWindowsPlatform() && MKerberosSingleLoginCredentials.useNativeSSO() ? MKerberosSingleLoginCredentials.getServiceTicketSSPI(string3) : MKerberosSingleLoginCredentials.getServiceTicketGSS(string3);
        return object;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
        if (debug) {
            System.out.println("SSO Debug enabled");
        }
    }

    public static void setNativeSSO(boolean bl) {
        if (debug) {
            System.out.println("Native SSO " + (bl ? "enabled" : "disabled"));
        }
        nativeSSO = bl;
    }

    public static void setupKerberosProperties(String string, String string2, Map<String, String> map, boolean bl) {
        File file = new File(MClientProperties.getUserDataDir(), "krb5.local.conf");
        if (!file.exists() && (map != null || bl)) {
            file = MKerberosSingleLoginCredentials.createKrb5ConfigurationFile("krb5.conf", string, map, bl);
        }
        if (file.exists()) {
            System.setProperty("java.security.krb5.conf", file.getAbsolutePath());
        } else {
            System.setProperty("java.security.krb5.realm", string);
            System.setProperty("java.security.krb5.kdc", string2);
        }
        System.setProperty("sun.security.krb5.debug", debug ? "true" : "false");
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        if (System.getProperty("java.security.auth.login.config") == null) {
            String string3 = debug ? "/conf/login.debug.conf" : "/conf/login.conf";
            System.setProperty("java.security.auth.login.config", MKerberosSingleLoginCredentials.translatePathToLocalClassPath(MKerberosSingleLoginCredentials.class, string3));
        }
        if (debug) {
            System.out.println("Realm is " + string);
            System.out.println("Kdc is " + string2);
        }
    }

    public static byte[] getTicketAs(String string, String string2, LoginCallBackHandler loginCallBackHandler) throws LoginException, SecurityException {
        byte[] byArray;
        if (MKerberosSingleLoginCredentials.isWindowsPlatform() && MKerberosSingleLoginCredentials.useNativeSSO()) {
            byArray = MKerberosSingleLoginCredentials.getServiceTicketSSPI(string);
        } else {
            LoginContext loginContext;
            try {
                loginContext = new LoginContext(string2, (CallbackHandler)loginCallBackHandler);
            }
            catch (LoginException loginException) {
                throw new SecurityException("Could not establish login context", loginException);
            }
            loginContext.login();
            Subject subject = loginContext.getSubject();
            byArray = (byte[])Subject.doAs(subject, new /* Unavailable Anonymous Inner Class!! */);
            try {
                loginContext.logout();
            }
            catch (LoginException loginException) {
                throw new SecurityException("Error at logout", loginException);
            }
        }
        return byArray;
    }

    public static byte[] getServiceTicketSSPI(String string) throws SecurityException {
        IWindowsCredentialsHandle iWindowsCredentialsHandle = null;
        IWindowsSecurityContext iWindowsSecurityContext = null;
        if (debug) {
            System.out.println();
            System.out.println("Trying to establish SSPI Context:");
            System.out.println("service name is " + string);
        }
        try {
            iWindowsSecurityContext = WindowsSecurityContextImpl.getCurrent("Kerberos", string);
            Sspi.SecBufferDesc secBufferDesc = null;
            do {
                iWindowsSecurityContext.initialize(iWindowsSecurityContext.getHandle(), secBufferDesc, string);
            } while (iWindowsSecurityContext.getContinue());
            if (debug) {
                System.out.println("Security Context established! ");
                System.out.println("User is " + iWindowsSecurityContext.getPrincipalName());
            }
            byte[] byArray = iWindowsSecurityContext.getToken();
            return byArray;
        }
        catch (Win32Exception win32Exception) {
            if (debug) {
                System.out.println("Error during attempted SSPI service ticket retrieval: " + win32Exception.getMessage() + "\n" + win32Exception.toString());
            }
            throw new SecurityException(win32Exception.getMessage(), win32Exception);
        }
        finally {
            if (iWindowsSecurityContext != null) {
                iWindowsSecurityContext.dispose();
            }
            if (iWindowsCredentialsHandle != null) {
                iWindowsCredentialsHandle.dispose();
            }
        }
    }

    public static byte[] getServiceTicketGSS(String string) throws SecurityException {
        try {
            if (debug) {
                System.out.println();
                System.out.println("Trying to establish GSS Context:");
                System.out.println("service name is " + string);
            }
            Oid oid = new Oid("1.2.840.113554.1.2.2");
            GSSManager gSSManager = GSSManager.getInstance();
            GSSName gSSName = gSSManager.createName(string, null);
            GSSContext gSSContext = gSSManager.createContext(gSSName, oid, null, 0);
            gSSContext.requestMutualAuth(false);
            byte[] byArray = new byte[]{};
            byArray = gSSContext.initSecContext(byArray, 0, byArray.length);
            if (!gSSContext.isEstablished()) {
                throw new SecurityException("Context not established");
            }
            if (debug) {
                System.out.println("Context Established! ");
                System.out.println("Client is " + gSSContext.getSrcName());
                System.out.println("Server is " + gSSContext.getTargName());
            }
            gSSContext.dispose();
            return byArray;
        }
        catch (GSSException gSSException) {
            if (debug) {
                System.out.println("GSSException: " + gSSException.getMessage() + "\n" + gSSException.toString());
            }
            throw new SecurityException(gSSException.getMessage(), gSSException);
        }
    }

    private static String translatePathToLocalClassPath(Class clazz, String string) {
        URL uRL;
        block5: {
            uRL = clazz.getResource(string);
            if (uRL == null) {
                throw new SecurityException("Single login : could not find resource: " + string);
            }
            if (MThisPlatform.getThisPlatform().isJava150_016()) {
                String string2;
                URL uRL2 = clazz.getProtectionDomain().getCodeSource().getLocation();
                String string3 = uRL2.toExternalForm();
                if (uRL != null && "jar".equalsIgnoreCase(uRL.getProtocol()) && uRL.toExternalForm().indexOf("!/") == -1 && !(string2 = "jar:" + string3 + "!" + string).equals(uRL.toExternalForm())) {
                    try {
                        uRL = new URL(string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (!debug) break block5;
                        System.out.println("URL translation failed for '" + uRL.toExternalForm() + "' -> '" + string2 + "': " + malformedURLException.getMessage());
                    }
                }
            }
        }
        return uRL.toExternalForm();
    }

    private static File createKrb5ConfigurationFile(String string, String string2, Map<String, String> map, boolean bl) {
        File file = new File(MClientProperties.getUserDataDir(), string);
        System.setProperty("java.security.krb5.conf", file.getAbsolutePath());
        if (!debug) {
            file.deleteOnExit();
        }
        try {
            if (debug) {
                System.out.println("Creating Kerberos configuration file:");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[libdefaults]\ndefault_realm = " + string2 + "\n");
            if (bl) {
                stringBuilder.append("allow_weak_crypto = true\n");
            } else {
                stringBuilder.append("\n");
            }
            if (map != null) {
                stringBuilder.append("[realms]\n");
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    stringBuilder.append(entry.getKey() + " = {\n  kdc = " + entry.getValue() + "\n}\n");
                }
            }
            ((OutputStream)fileOutputStream).write(stringBuilder.toString().getBytes());
            ((OutputStream)fileOutputStream).close();
            if (debug) {
                System.out.println(stringBuilder.toString());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SecurityException("Could not create file: " + file.getAbsolutePath() + " (" + fileNotFoundException.getMessage() + ")");
        }
        catch (IOException iOException) {
            throw new SecurityException("Could not write to file: " + file.getAbsolutePath() + " (" + iOException.getMessage() + ")");
        }
        return file;
    }

    private static boolean useNativeSSO() {
        String string = System.getProperty("com.maconomy.native-sso");
        return nativeSSO && (string == null || Boolean.parseBoolean(string));
    }

    private static boolean isWindowsPlatform() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("win") >= 0;
    }
}

