/*
 * Decompiled with CFR 0.152.
 */
package com.maconomy.client;

import com.maconomy.util.MInternalError;
import com.maconomy.util.MThisPlatform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.roydesign.mac.MRJAdapter;
import org.apache.commons.lang.SystemUtils;

public final class MClientProperties {
    private static final int UserSettingsFormat = 3;
    private static final String UNKNOWN = "N/A";
    private static final Properties properties = new Properties();
    private static File analyzerOutputDir;
    private static File imageOutputDir;
    private static File userDataDir;
    private static File userIconDir;
    private static File userCacheDir;

    public static synchronized String getClientRevision() {
        return properties.getProperty("jaconomy.revision", UNKNOWN);
    }

    public static synchronized String getClientVersion() {
        return properties.getProperty("jaconomy.version", UNKNOWN);
    }

    public static synchronized String getBuildYear() {
        return properties.getProperty("jaconomy.buildyear", UNKNOWN);
    }

    public static int getUserSettingsFormat() {
        return 3;
    }

    public static synchronized File getAnalyzerOutputDir() {
        if (analyzerOutputDir == null) {
            analyzerOutputDir = new File(MClientProperties.getUserDataDir(), "AnalyzerOutput");
            if (!analyzerOutputDir.exists()) {
                analyzerOutputDir.mkdirs();
            }
            if (!analyzerOutputDir.exists()) {
                throw new MInternalError("Could not create analyzer output directory : " + analyzerOutputDir.toString());
            }
        }
        return analyzerOutputDir;
    }

    public static synchronized File getImageOutputDir() {
        if (imageOutputDir == null) {
            imageOutputDir = new File(MClientProperties.getUserDataDir(), "Images");
            if (!imageOutputDir.exists()) {
                imageOutputDir.mkdirs();
            }
            if (!imageOutputDir.exists()) {
                throw new MInternalError("Could not create image directory : " + imageOutputDir.toString());
            }
        }
        return imageOutputDir;
    }

    private static synchronized File getUserSubDir(File file, String string) {
        File file2;
        File file3 = file2 = string != null ? new File(new File(new File(file, "Maconomy"), "Jaconomy"), string) : new File(new File(file, "Maconomy"), "Jaconomy");
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    private static synchronized File getUserDir(String string, int n, String string2, String string3) {
        File file;
        File file2 = null;
        if (MThisPlatform.getThisPlatform().isWindows() && (file = MClientProperties.getAppDataDir()) != null && file.isAbsolute() && file.isDirectory()) {
            file2 = MClientProperties.getUserSubDir(file, string);
        }
        if (file2 == null) {
            try {
                file = MRJAdapter.findFolder((short)-32763, (int)n, (boolean)true);
                if (file.isDirectory()) {
                    file2 = MClientProperties.getUserSubDir(file, string2);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (file2 == null) {
                file2 = MClientProperties.getUserSubDir(new File(SystemUtils.USER_HOME, ".jaconomy"), string3);
            }
        }
        return file2;
    }

    public static synchronized File getUserDataDir() {
        if (userDataDir == null) {
            userDataDir = MClientProperties.getUserDir(null, 1634956656, null, null);
        }
        return userDataDir;
    }

    public static synchronized File getUserIconDir() {
        if (userIconDir == null) {
            userIconDir = MClientProperties.getUserDir("Icons", 1634956656, null, "Icons");
        }
        return userIconDir;
    }

    public static synchronized File getUserCacheDir(String string) {
        if (userCacheDir == null) {
            userCacheDir = MClientProperties.getCacheDir(string);
        }
        return userCacheDir;
    }

    public static synchronized File getCacheDir() {
        return MClientProperties.getCacheDir(null);
    }

    private static File getCacheDir(String string) {
        File file = MClientProperties.getUserDir("Cache", 1667326824, null, "Cache");
        if (string != null) {
            String string2 = "" + Math.abs(string.hashCode());
            String string3 = "Cache" + string2;
            file = new File(file, string3);
        }
        return file;
    }

    private static File getAppDataDir() {
        File file = new File(SystemUtils.USER_HOME, "Application Data");
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static String getDebugFileName() {
        return "debug";
    }

    public static String getDebugSettingsFileName() {
        return "debugset";
    }

    public static String getDebugLogFileName() {
        return "debuglogfile.txt";
    }

    public static String getClearUserSettingsFileName() {
        return "clearusersettings";
    }

    public static String getProgramSlowLoginFileName() {
        return "programslowlogin";
    }

    public static File findFile(File file, String string) {
        return MClientProperties.findFile(file, string, true);
    }

    public static File findFile(File file, String string, boolean bl) {
        File file2 = new File(file, string);
        if (file2.exists()) {
            return file2;
        }
        if (bl) {
            File file3 = file.getParentFile();
            if (file3 == null) {
                return null;
            }
            return MClientProperties.findFile(file3, string);
        }
        return null;
    }

    static {
        InputStream inputStream = MClientProperties.class.getResourceAsStream("/properties.txt");
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

