/*
 * Decompiled with CFR 0.152.
 */
package com.maconomy.util;

import com.maconomy.util.MClassUtil;
import com.maconomy.util.MIStringUtil;
import com.maconomy.util.MInternalError;
import com.maconomy.util.MMathUtil;
import com.maconomy.util.MReflectionUtil;
import com.maconomy.util.MThisPlatform;
import com.maconomy.util.MURLEncoder;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.text.BreakIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MStringUtil {
    private static Object stringUtilLock = new Object();
    private static MIStringUtil stringUtil;
    private static final double epsilon;
    private static final Map<Integer, String> cachedDecimals;
    private static final WeakHashMap<String, String> toUpperCaseCache;
    private static final Locale danishLocale;
    private static final WeakHashMap<String, String> toDanishUpperCaseCache;
    private static final WeakHashMap<String, String> toLowerCaseCache;
    private static final WeakHashMap<String, String> toDanishLowerCaseCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MIStringUtil getStringUtil() {
        Object object = stringUtilLock;
        synchronized (object) {
            if (stringUtil != null) return stringUtil;
            if (MThisPlatform.getThisPlatform().isJava160OrNewer()) {
                Class clazz = MClassUtil.loadClassByReflection((String)"com.maconomy.util.MStringUtil16");
                if (clazz == null) return stringUtil;
                Object object2 = MReflectionUtil.constructObjectByReflection((Class)clazz, (Class[])new Class[0], (Object[])new Object[0]);
                if (!(object2 instanceof MIStringUtil)) throw new MInternalError("Unable to create UNICODE normalizer for Java 1.6 and later");
                stringUtil = (MIStringUtil)object2;
            } else {
                Class clazz = MClassUtil.loadClassByReflection((String)"com.maconomy.util.MStringUtil15");
                if (clazz == null) return stringUtil;
                Object object3 = MReflectionUtil.constructObjectByReflection((Class)clazz, (Class[])new Class[0], (Object[])new Object[0]);
                if (!(object3 instanceof MIStringUtil)) throw new MInternalError("Unable to create UNICODE normalizer for Java 1.5");
                stringUtil = (MIStringUtil)object3;
            }
            return stringUtil;
        }
    }

    public static String addArgToURL(String string, String string2, String string3, String string4) throws UnsupportedEncodingException {
        String string5 = MURLEncoder.encode((String)MStringUtil.normalize(string2), (String)string4) + "=" + MURLEncoder.encode((String)MStringUtil.normalize(string3), (String)string4);
        if (string.endsWith("?")) {
            return string + string5;
        }
        if (string.indexOf(63) == -1) {
            return string + '?' + string5;
        }
        return string + '&' + string5;
    }

    public static URL addArgToURL(URL uRL, String string, String string2, String string3) throws UnsupportedEncodingException {
        String string4 = uRL.toExternalForm();
        string4 = MStringUtil.addArgToURL(string4, string, string2, string3);
        try {
            return new URL(string4);
        }
        catch (MalformedURLException malformedURLException) {
            throw new MInternalError(malformedURLException);
        }
    }

    public static String expandString(String string, char c) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        for (int i = 1; i < n - 1; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                if (bl) {
                    stringBuilder.append(c2);
                    bl = false;
                    continue;
                }
                bl = true;
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String removeChar(String string, char c) {
        String string2 = "";
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == c) continue;
            string2 = string2 + cArray[i];
        }
        return string2;
    }

    public static String showValue(String string, Object object) {
        return string + " = " + object;
    }

    public static String showValue(String string, String string2) {
        return string + (string2 == null ? "= null" : " = \"" + string2 + "\"");
    }

    public static String substitute(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(string2, n)) == -1) {
                stringBuilder.append(string.substring(n));
                return stringBuilder.toString();
            }
            stringBuilder.append(string.substring(n, n2));
            stringBuilder.append(string3);
            n = n2 + string2.length();
        }
    }

    public static String toString(List<?> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String toString(Map<?, ?> map, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Set<Map.Entry<?, ?>> set = map.entrySet();
        Iterator<Map.Entry<?, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            stringBuilder.append('(').append(entry.getKey().toString()).append(" --> ").append(entry.getValue()).append(')');
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String formatDecimal(double d, int n, char c, char c2, int n2, boolean bl) {
        DecimalFormat decimalFormat;
        Object object;
        if (d == 0.0 && bl) {
            return "";
        }
        double d2 = d == 0.0 ? d : new BigDecimal(d > 0.0 ? d + epsilon : d - epsilon).setScale(n, 4).doubleValue();
        if (d2 == 0.0 && bl) {
            return "";
        }
        if (n > 0) {
            object = cachedDecimals.get(n);
            if (object == null) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append('0');
                }
                String string = stringBuilder.toString();
                object = "0." + string + ";" + "-0." + string;
                cachedDecimals.put(n, (String)object);
            }
            decimalFormat = new DecimalFormat((String)object);
        } else {
            decimalFormat = new DecimalFormat("0;-0");
        }
        decimalFormat.setGroupingSize(n2);
        decimalFormat.setGroupingUsed(Character.isDefined(c2));
        object = new DecimalFormatSymbols();
        ((DecimalFormatSymbols)object).setDecimalSeparator(c);
        ((DecimalFormatSymbols)object).setGroupingSeparator(c2);
        decimalFormat.setDecimalFormatSymbols((DecimalFormatSymbols)object);
        return decimalFormat.format(d2);
    }

    public static String cachedToUpperCase(String string) {
        String string2 = toUpperCaseCache.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = string.toUpperCase();
        toUpperCaseCache.put(string, string2);
        return string2;
    }

    public static String cachedToDanishUpperCase(String string) {
        String string2 = toDanishUpperCaseCache.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = string.toUpperCase(danishLocale);
        toDanishUpperCaseCache.put(string, string2);
        return string2;
    }

    public static String cachedToLowerCase(String string) {
        String string2 = toLowerCaseCache.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = string.toLowerCase();
        toLowerCaseCache.put(string, string2);
        return string2;
    }

    public static String cachedToDanishLowerCase(String string) {
        String string2 = toDanishLowerCaseCache.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = string.toLowerCase(danishLocale);
        toDanishLowerCaseCache.put(string, string2);
        return string2;
    }

    public static String toDanishLowerCase(String string) {
        return string.toLowerCase(danishLocale);
    }

    public static String normalize(String string) {
        return MStringUtil.getStringUtil().normalize(string);
    }

    public static byte[] normalizeAndGetBytes(String string, String string2) throws UnsupportedEncodingException {
        return MStringUtil.getStringUtil().normalizeAndGetBytes(string, string2);
    }

    public static boolean isStringEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static String removeWhiteSpace(String string) {
        if (string != null) {
            int n = string.length();
            if (n > 0) {
                int n2;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                for (int i = 0; i < n; i += Character.charCount(n2)) {
                    n2 = string.codePointAt(i);
                    if (Character.isSpaceChar(n2)) {
                        bl = true;
                        continue;
                    }
                    stringBuilder.appendCodePoint(n2);
                }
                if (bl) {
                    return stringBuilder.toString();
                }
                return string;
            }
            return string;
        }
        return null;
    }

    public static String escapeStringIf(String string, boolean bl) {
        if (string != null) {
            if (bl) {
                if (string.indexOf(10) != -1) {
                    return "%[ESC-CHAR-5C]" + string.replace("\\", "\\\\").replace("\n", "\\n");
                }
                return string;
            }
            return string;
        }
        return null;
    }

    public static int LevenshteinDistance(String string, String string2) {
        int n;
        int n2;
        int n3 = string.length();
        int n4 = string2.length();
        if (n3 == 0) {
            return n4;
        }
        if (n4 == 0) {
            return n3;
        }
        int[][] nArray = new int[n3 + 1][n4 + 1];
        for (n2 = 0; n2 <= n3; ++n2) {
            nArray[n2][0] = n2;
        }
        for (n = 0; n <= n4; ++n) {
            nArray[0][n] = n;
        }
        for (n2 = 1; n2 <= n3; ++n2) {
            char c = string.charAt(n2 - 1);
            for (n = 1; n <= n4; ++n) {
                char c2 = string2.charAt(n - 1);
                int n5 = c == c2 ? 0 : 1;
                nArray[n2][n] = MMathUtil.min((int)(nArray[n2 - 1][n] + 1), (int)(nArray[n2][n - 1] + 1), (int)(nArray[n2 - 1][n - 1] + n5));
            }
        }
        return nArray[n3][n4];
    }

    private static ByteBuffer extendByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            return ByteBuffer.allocate(byteBuffer.capacity() * 2).put(byteBuffer);
        }
        return null;
    }

    public static String getSurrogateCharacterAt(String string, boolean bl, int n) {
        if (string != null) {
            if (n >= 0 && n < string.length()) {
                if (bl) {
                    BreakIterator breakIterator = BreakIterator.getCharacterInstance(Locale.US);
                    String string2 = string.substring(n);
                    breakIterator.setText(string2);
                    int n2 = breakIterator.current();
                    int n3 = breakIterator.next();
                    if (n3 != -1) {
                        return string2.substring(n2, n3);
                    }
                    return string2.substring(n2);
                }
                char c = string.charAt(n);
                if (Character.isHighSurrogate(c)) {
                    if (n + 1 < string.length()) {
                        char c2 = string.charAt(n + 1);
                        if (Character.isLowSurrogate(c2)) {
                            return new String(new char[]{c, c2});
                        }
                        return new String(new char[]{c});
                    }
                    return new String(new char[]{c});
                }
                return new String(new char[]{c});
            }
            throw new IllegalArgumentException("'i' not in range allowed by 's'. 'i' = " + n + " , 's' = '" + string + "'");
        }
        throw new IllegalArgumentException("'s' must be != null");
    }

    public static int getCharacterAt(String string, int n) {
        return MStringUtil.getSurrogateCharacterAt(string, false, n).codePointAt(0);
    }

    public static Set<String> checkSurrogates(String string, boolean bl) {
        if (MStringUtil.isStringEmpty(string)) {
            return Collections.emptySet();
        }
        if (bl) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isHighSurrogate(c)) continue;
            String string2 = MStringUtil.getSurrogateCharacterAt(string, true, i);
            hashSet.add(string2);
            i += string2.length() - 1;
        }
        return hashSet;
    }

    public static Set<String> checkEncoding(String string, String string2) {
        Charset charset = Charset.forName(string2);
        if (charset != null) {
            CoderResult coderResult;
            if (MStringUtil.isStringEmpty(string)) {
                return Collections.emptySet();
            }
            HashSet<String> hashSet = new HashSet<String>();
            CharsetEncoder charsetEncoder = charset.newEncoder();
            charsetEncoder.reset();
            CharBuffer charBuffer = CharBuffer.allocate(string.length());
            ByteBuffer byteBuffer = ByteBuffer.allocate(string.length() * 4);
            charBuffer.append(string);
            charBuffer.flip();
            while (charBuffer.hasRemaining()) {
                coderResult = charsetEncoder.encode(charBuffer, byteBuffer, false);
                if (coderResult.isUnderflow() && charBuffer.hasRemaining()) {
                    charBuffer.get();
                    continue;
                }
                if (coderResult.isOverflow()) {
                    byteBuffer = MStringUtil.extendByteBuffer(byteBuffer);
                    continue;
                }
                if (!coderResult.isError() || !charBuffer.hasRemaining()) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < coderResult.length(); ++i) {
                    stringBuilder.append(charBuffer.get());
                }
                hashSet.add(stringBuilder.toString());
            }
            while ((coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true)).isOverflow()) {
                byteBuffer = MStringUtil.extendByteBuffer(byteBuffer);
            }
            while ((coderResult = charsetEncoder.flush(byteBuffer)).isOverflow()) {
                byteBuffer = MStringUtil.extendByteBuffer(byteBuffer);
            }
            return hashSet;
        }
        return Collections.emptySet();
    }

    static {
        epsilon = Math.pow(10.0, -11.0);
        cachedDecimals = new HashMap<Integer, String>();
        toUpperCaseCache = new WeakHashMap();
        danishLocale = new Locale("da", "DK");
        toDanishUpperCaseCache = new WeakHashMap();
        toLowerCaseCache = new WeakHashMap();
        toDanishLowerCaseCache = new WeakHashMap();
    }
}

