/*
 * Decompiled with CFR 0.152.
 */
package com.maconomy.gss.client.sspi;

import com.maconomy.gss.client.sspi.IWindowsCredentialsHandle;
import com.sun.jna.platform.win32.Secur32;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;

public class WindowsCredentialsHandleImpl
implements IWindowsCredentialsHandle {
    private static volatile boolean debug = false;
    private String _principalName = null;
    private int _credentialsType = 0;
    private String _securityPackage = null;
    private Sspi.CredHandle _handle = null;
    private Sspi.TimeStamp _clientLifetime = null;

    public static IWindowsCredentialsHandle getCurrent(String string, String string2) {
        WindowsCredentialsHandleImpl windowsCredentialsHandleImpl = new WindowsCredentialsHandleImpl(string, 2, string2);
        windowsCredentialsHandleImpl.initialize();
        return windowsCredentialsHandleImpl;
    }

    public WindowsCredentialsHandleImpl(String string, int n, String string2) {
        this._principalName = string;
        this._credentialsType = n;
        this._securityPackage = string2;
    }

    public void initialize() {
        this._handle = new Sspi.CredHandle();
        this._clientLifetime = new Sspi.TimeStamp();
        int n = Secur32.INSTANCE.AcquireCredentialsHandle(this._principalName, this._securityPackage, this._credentialsType, null, null, null, null, this._handle, this._clientLifetime);
        if (0 != n) {
            if (debug) {
                System.out.println("Error during attempted SSPI service ticket retrieval: AcquireCredentialsHandle function ");
            }
            throw new Win32Exception(n);
        }
        if (debug) {
            System.out.println("SSPI service ticket retrieval: Credential Handle initialized ");
        }
    }

    public void dispose() {
        if (this._handle != null && !this._handle.isNull()) {
            int n = Secur32.INSTANCE.FreeCredentialsHandle(this._handle);
            if (0 != n) {
                if (debug) {
                    System.out.println("Error during attempted SSPI service ticket retrieval: Disposibg Credential Handle ");
                }
                throw new Win32Exception(n);
            }
            this._handle = null;
        }
    }

    public Sspi.CredHandle getHandle() {
        return this._handle;
    }

    public void setDebug(boolean bl) {
        debug = bl;
    }
}

